/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.apps.ts.dashboard.renderers;

import com.efiAnalytics.apps.ts.dashboard.Indicator;
import com.efiAnalytics.apps.ts.dashboard.renderers.IndicatorPainter;
import com.efiAnalytics.apps.ts.dashboard.s;
import com.efiAnalytics.ui.cq;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import r.a;

public class RectangleIndicatorPainter
implements IndicatorPainter {
    static String NAME = "Basic Rectangle Indicator";
    transient Font textFont = null;
    transient Image offImage = null;
    int lastWidth = -1;
    int lastHeight = -1;
    double lastValue = Double.NaN;
    Area onImageArea = null;
    Area offImageArea = null;
    private boolean maskImages = a.a().c(a.al, false);

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void paintGauge(Graphics graphics, s s2) {
        Indicator indicator = (Indicator)s2;
        this.lastWidth = s2.getWidth();
        this.lastHeight = s2.getHeight();
        this.lastValue = indicator.getValue();
        if (indicator.getValue() == 0.0) {
            Color color = indicator.getOffBackgroundColor();
            this.drawBackground(graphics, indicator, color);
            if (indicator.offImage() != null) {
                Image image = indicator.offImage();
                float f2 = this.getImageScaleRatio(indicator, image);
                int n2 = (int)((float)image.getWidth(null) * f2);
                int n3 = (int)((float)image.getHeight(null) * f2);
                graphics.drawImage(image, (indicator.getWidth() - n2) / 2, (indicator.getHeight() - n3) / 2, n2, n3, null);
                if (this.maskImages && this.offImageArea == null) {
                    this.offImageArea = this.getImageOutline(indicator, image, f2);
                }
            }
            this.drawText(graphics, indicator.offText(), indicator, indicator.getOffTextColor());
        } else {
            Color color = indicator.getOnBackgroundColor();
            this.drawBackground(graphics, indicator, color);
            if (indicator.onImage() != null) {
                Image image = indicator.onImage();
                float f3 = this.getImageScaleRatio(indicator, image);
                int n4 = (int)((float)image.getWidth(null) * f3);
                int n5 = (int)((float)image.getHeight(null) * f3);
                graphics.drawImage(image, (indicator.getWidth() - n4) / 2, (indicator.getHeight() - n5) / 2, n4, n5, null);
                if (this.maskImages && this.onImageArea == null) {
                    this.onImageArea = this.getImageOutline(indicator, image, f3);
                }
            }
            this.drawText(graphics, indicator.onText(), indicator, indicator.getOnTextColor());
        }
    }

    private float getImageScaleRatio(Indicator indicator, Image image) {
        if (image != null) {
            float f2;
            float f3 = (float)indicator.getWidth() / (float)image.getWidth(null);
            return f3 < (f2 = (float)indicator.getHeight() / (float)image.getHeight(null)) ? f3 : f2;
        }
        return 1.0f;
    }

    private void drawBackground(Graphics graphics, Indicator indicator, Color color) {
        if (color != null && color.getAlpha() > 0) {
            graphics.setColor(color);
            graphics.fill3DRect(0, 0, indicator.getWidth(), indicator.getHeight(), true);
            graphics.draw3DRect(1, 1, indicator.getWidth() - 3, indicator.getHeight() - 3, true);
        }
    }

    private void drawText(Graphics graphics, String string, Indicator indicator, Color color) {
        Object object;
        if (indicator.isAntialiasingOn()) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        graphics.setColor(color);
        object = this.getTextFont(indicator);
        graphics.setFont((Font)object);
        int n2 = (indicator.getWidth() - indicator.getFontMetrics((Font)object).stringWidth(string)) / 2;
        int n3 = (int)((double)(indicator.getHeight() / 2) + (double)((Font)object).getSize() * 0.36);
        graphics.drawString(string, n2, n3);
    }

    protected Font getTextFont(Indicator indicator) {
        if (this.textFont != null) {
            return this.textFont;
        }
        int n2 = (int)((double)(indicator.getHeight() - indicator.insets().top - indicator.insets().bottom) * 0.98);
        int n3 = indicator.getWidth() - indicator.insets().left - indicator.insets().right;
        String string = indicator.getFontFamily();
        int n4 = indicator.isItalicFont() ? 2 : 0;
        Font font = cq.a().a(string, n4, n2);
        if (font.canDisplayUpTo(indicator.onText()) >= 0 && font.canDisplayUpTo(indicator.offText()) >= 0) {
            font = cq.a().a("", n4, n2);
        }
        while (true) {
            FontMetrics fontMetrics;
            if ((fontMetrics = indicator.getFontMetrics(font)).stringWidth(indicator.onText()) < n3 && fontMetrics.stringWidth(indicator.offText()) < n3 || n2 < 1) {
                this.textFont = font;
                return this.textFont;
            }
            font = cq.a().a(string, n4, --n2);
        }
    }

    @Override
    public void invalidate() {
        this.textFont = null;
        this.offImage = null;
        this.onImageArea = null;
        this.offImageArea = null;
    }

    @Override
    public boolean isMustPaint() {
        return false;
    }

    @Override
    public boolean requiresBackgroundRepaint(s s2) {
        Indicator indicator = (Indicator)s2;
        return s2.getWidth() != this.lastWidth || s2.getHeight() != this.lastHeight || indicator.getValue() != this.lastValue || this.textFont == null;
    }

    @Override
    public void updateGauge(Graphics graphics, s s2) {
    }

    @Override
    public void paintBackground(Graphics graphics, s s2) {
        this.paintGauge(graphics, s2);
    }

    @Override
    public Area areaPainted(s s2) {
        Area area;
        Color color;
        Indicator indicator = (Indicator)s2;
        Color color2 = color = indicator.getValue() == 0.0 ? indicator.getOffBackgroundColor() : indicator.getOnBackgroundColor();
        if (color != null && color.getAlpha() > 0) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, s2.getWidth(), s2.getHeight());
            area = new Area(double_);
        } else {
            area = indicator.getValue() == 0.0 && this.offImageArea != null ? (Area)this.offImageArea.clone() : (this.onImageArea != null ? (Area)this.onImageArea.clone() : new Area(new Rectangle2D.Double(0.0, 0.0, s2.getWidth(), s2.getHeight())));
        }
        return area;
    }

    private Area getImageOutline(Indicator indicator, Image image, double d2) {
        int n2 = (int)((double)image.getWidth(indicator) * d2);
        int n3 = (int)((double)image.getHeight(indicator) * d2);
        if (n2 <= 0 || n3 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(indicator.getWidth(), indicator.getHeight(), 6);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, (indicator.getWidth() - n2) / 2, (indicator.getHeight() - n3) / 2, n2, n3, null);
        return this.getImageOutline(bufferedImage);
    }

    private Area getImageOutline(BufferedImage bufferedImage) {
        Area area = new Area();
        int n2 = -1;
        int n3 = -1;
        if (bufferedImage.getHeight() < 256 && bufferedImage.getWidth() < 256) {
            for (int i2 = 0; i2 < bufferedImage.getHeight(); ++i2) {
                for (int i3 = 0; i3 < bufferedImage.getWidth(); ++i3) {
                    Rectangle rectangle;
                    if (this.getAlpha(bufferedImage.getRGB(i3, i2)) != 0) {
                        if (n2 == -1) {
                            n2 = i3;
                            n3 = i2;
                            continue;
                        }
                        if (i3 != bufferedImage.getWidth() - 1) continue;
                        rectangle = new Rectangle(n2, n3, i3 - n2 + 1, i2 - n3 + 1);
                        area.add(new Area(rectangle));
                        n2 = -1;
                        n3 = -1;
                        continue;
                    }
                    if (n2 < 0 || n3 < 0) continue;
                    rectangle = new Rectangle(n2, n3, i3 - n2 + 1, i2 - n3 + 1);
                    area.add(new Area(rectangle));
                    n2 = -1;
                    n3 = -1;
                }
            }
        } else {
            int n4;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = bufferedImage.getHeight() / 2;
            int n10 = bufferedImage.getWidth() / 2;
            for (n4 = 0; n4 < bufferedImage.getWidth(); ++n4) {
                if (this.getAlpha(bufferedImage.getRGB(n4, n9)) == 0) continue;
                n7 = n4;
                break;
            }
            for (n4 = bufferedImage.getWidth() - 1; n4 > 0; --n4) {
                if (this.getAlpha(bufferedImage.getRGB(n4, n9)) == 0) continue;
                n8 = n4;
                break;
            }
            for (n4 = 0; n4 < bufferedImage.getHeight(); ++n4) {
                if (this.getAlpha(bufferedImage.getRGB(n10, n4)) == 0) continue;
                n5 = n4;
                break;
            }
            for (n4 = bufferedImage.getHeight() - 1; n4 > 0; --n4) {
                if (this.getAlpha(bufferedImage.getRGB(n10, n4)) == 0) continue;
                n6 = n4;
                break;
            }
            if (n8 > 0 && n6 > 0) {
                area.add(new Area(new Rectangle(n7, n5, n8 - n7 + 1, n6 - n5 + 1)));
            }
        }
        if (area.getBounds().isEmpty()) {
            return null;
        }
        return area;
    }

    private int getAlpha(int n2) {
        return n2 >> 24 & 0xFF;
    }
}

