/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinyScrollBarUI;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicArrowButton;

public class TinyScrollButton
extends BasicArrowButton {
    private static final HashMap cache = new HashMap();
    private boolean isRollover;
    private TinyScrollBarUI scrollbarUI;

    public static void clearCache() {
        cache.clear();
    }

    public TinyScrollButton(int n, TinyScrollBarUI tinyScrollBarUI) {
        super(n);
        this.scrollbarUI = tinyScrollBarUI;
        this.setBorder(null);
        this.setRolloverEnabled(true);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setSize(this.getPreferredSize());
    }

    public void paint(Graphics graphics) {
        boolean bl = this.scrollbarUI.isThumbVisible();
        this.isRollover = false;
        ColorUIResource colorUIResource = null;
        if (!bl) {
            colorUIResource = Theme.scrollButtDisabledColor.getColor();
        } else if (this.getModel().isPressed()) {
            colorUIResource = Theme.scrollButtPressedColor.getColor();
        } else if (this.getModel().isRollover() && Theme.scrollRollover.getValue()) {
            colorUIResource = Theme.scrollButtRolloverColor.getColor();
            this.isRollover = true;
        } else {
            colorUIResource = Theme.scrollButtColor.getColor();
        }
        graphics.setColor(colorUIResource);
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.drawXpButtonNoCache(graphics, this.getSize(), colorUIResource);
        } else {
            this.drawXpButton(graphics, this.getSize(), colorUIResource);
        }
        if (!bl) {
            graphics.setColor(Theme.scrollArrowDisabledColor.getColor());
        } else {
            graphics.setColor(Theme.scrollArrowColor.getColor());
        }
        this.drawXpArrow(graphics, this.getSize());
    }

    private void drawXpButton(Graphics graphics, Dimension dimension, Color color) {
        boolean bl;
        boolean bl2;
        boolean bl3 = this.scrollbarUI.isThumbVisible();
        ScrollButtonKey scrollButtonKey = new ScrollButtonKey(dimension, this.direction == 1 || this.direction == 5, color, bl2 = this.getModel().isPressed(), bl3, bl = this.getModel().isRollover() && Theme.scrollRollover.getValue());
        Object v = cache.get(scrollButtonKey);
        if (v != null) {
            graphics.drawImage((Image)v, 0, 0, this);
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics graphics2 = ((Image)bufferedImage).getGraphics();
        int n = dimension.height;
        int n2 = dimension.width;
        int n3 = Theme.scrollSpreadLight.getValue();
        int n4 = Theme.scrollSpreadDark.getValue();
        if (!bl3) {
            n3 = Theme.scrollSpreadLightDisabled.getValue();
            n4 = Theme.scrollSpreadDarkDisabled.getValue();
        }
        switch (this.direction) {
            case 1: 
            case 5: {
                float f = 10.0f * (float)n3 / 10.0f;
                float f2 = 10.0f * (float)n4 / 10.0f;
                int n5 = n * 3 / 8;
                for (int i = 1; i < n - 1; ++i) {
                    int n6;
                    if (i < n5) {
                        n6 = n5 - i;
                        graphics2.setColor(ColorRoutines.lighten(color, (int)((float)n6 * f)));
                    } else if (i == n5) {
                        graphics2.setColor(color);
                    } else {
                        n6 = i - n5;
                        graphics2.setColor(ColorRoutines.darken(color, (int)((float)n6 * f2)));
                    }
                    graphics2.drawLine(3, i, n2 - 3, i);
                }
                graphics2.setColor(Theme.scrollTrackBorderColor.getColor());
                graphics2.drawLine(0, 0, 0, n - 1);
                color = !bl3 ? Theme.scrollLightDisabledColor.getColor() : Theme.scrollBorderLightColor.getColor();
                graphics2.setColor(color);
                graphics2.drawLine(2, 1, 2, n - 2);
                graphics2.drawLine(n2 - 2, 1, n2 - 2, n - 2);
                Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 92);
                color = !bl3 ? Theme.scrollBorderDisabledColor.getColor() : Theme.scrollBorderColor.getColor();
                graphics2.setColor(color);
                graphics2.drawRect(1, 0, n2 - 2, n - 1);
                graphics2.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 92));
                graphics2.drawLine(2, 1, 2, 1);
                graphics2.drawLine(n2 - 2, 1, n2 - 2, 1);
                graphics2.drawLine(2, n - 2, 2, n - 2);
                graphics2.drawLine(n2 - 2, n - 2, n2 - 2, n - 2);
                graphics2.setColor(color2);
                graphics2.drawLine(1, 0, 1, 0);
                graphics2.drawLine(1, n - 1, 1, n - 1);
                graphics2.drawLine(n2 - 1, 0, n2 - 1, 0);
                graphics2.drawLine(n2 - 1, n - 1, n2 - 1, n - 1);
                break;
            }
            case 3: 
            case 7: {
                float f = 10.0f * (float)n3 / 10.0f;
                float f3 = 10.0f * (float)n4 / 10.0f;
                int n7 = n / 2;
                for (int i = 1; i < n2 - 1; ++i) {
                    int n8;
                    if (i < n7) {
                        n8 = n7 - i;
                        graphics2.setColor(ColorRoutines.lighten(color, (int)((float)n8 * f)));
                    } else if (i == n7) {
                        graphics2.setColor(color);
                    } else {
                        n8 = i - n7;
                        graphics2.setColor(ColorRoutines.darken(color, (int)((float)n8 * f3)));
                    }
                    graphics2.drawLine(2, i + 1, n2 - 3, i + 1);
                }
                graphics2.setColor(Theme.scrollTrackBorderColor.getColor());
                graphics2.drawLine(0, 0, n2 - 1, 0);
                color = !bl3 ? Theme.scrollLightDisabledColor.getColor() : Theme.scrollBorderLightColor.getColor();
                graphics2.setColor(color);
                graphics2.drawLine(1, 2, 1, n - 2);
                graphics2.drawLine(n2 - 2, 2, n2 - 2, n - 2);
                Color color3 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 92);
                color = !bl3 ? Theme.scrollBorderDisabledColor.getColor() : Theme.scrollBorderColor.getColor();
                graphics2.setColor(color);
                graphics2.drawRect(0, 1, n2 - 1, n - 2);
                graphics2.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 92));
                graphics2.drawLine(1, 2, 1, 2);
                graphics2.drawLine(n2 - 2, 2, n2 - 2, 2);
                graphics2.drawLine(1, n - 2, 1, n - 2);
                graphics2.drawLine(n2 - 2, n - 2, n2 - 2, n - 2);
                graphics2.setColor(color3);
                graphics2.drawLine(0, 1, 0, 1);
                graphics2.drawLine(n2 - 1, 1, n2 - 1, 1);
                graphics2.drawLine(0, n - 1, 0, n - 1);
                graphics2.drawLine(n2 - 1, n - 1, n2 - 1, n - 1);
            }
        }
        graphics2.dispose();
        graphics.drawImage(bufferedImage, 0, 0, this);
        cache.put(scrollButtonKey, bufferedImage);
    }

    private void drawXpButtonNoCache(Graphics graphics, Dimension dimension, Color color) {
        boolean bl = this.scrollbarUI.isThumbVisible();
        int n = dimension.height;
        int n2 = dimension.width;
        int n3 = Theme.scrollSpreadLight.getValue();
        int n4 = Theme.scrollSpreadDark.getValue();
        if (!bl) {
            n3 = Theme.scrollSpreadLightDisabled.getValue();
            n4 = Theme.scrollSpreadDarkDisabled.getValue();
        }
        switch (this.direction) {
            case 1: 
            case 5: {
                float f = 10.0f * (float)n3 / 10.0f;
                float f2 = 10.0f * (float)n4 / 10.0f;
                int n5 = n * 3 / 8;
                for (int i = 1; i < n - 1; ++i) {
                    int n6;
                    if (i < n5) {
                        n6 = n5 - i;
                        graphics.setColor(ColorRoutines.lighten(color, (int)((float)n6 * f)));
                    } else if (i == n5) {
                        graphics.setColor(color);
                    } else {
                        n6 = i - n5;
                        graphics.setColor(ColorRoutines.darken(color, (int)((float)n6 * f2)));
                    }
                    graphics.drawLine(3, i, n2 - 3, i);
                }
                graphics.setColor(Theme.scrollTrackBorderColor.getColor());
                graphics.drawLine(0, 0, 0, n - 1);
                color = !bl ? Theme.scrollLightDisabledColor.getColor() : Theme.scrollBorderLightColor.getColor();
                graphics.setColor(color);
                graphics.drawLine(2, 1, 2, n - 2);
                graphics.drawLine(n2 - 2, 1, n2 - 2, n - 2);
                Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 92);
                color = !bl ? Theme.scrollBorderDisabledColor.getColor() : Theme.scrollBorderColor.getColor();
                graphics.setColor(color);
                graphics.drawRect(1, 0, n2 - 2, n - 1);
                graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 92));
                graphics.drawLine(2, 1, 2, 1);
                graphics.drawLine(n2 - 2, 1, n2 - 2, 1);
                graphics.drawLine(2, n - 2, 2, n - 2);
                graphics.drawLine(n2 - 2, n - 2, n2 - 2, n - 2);
                graphics.setColor(color2);
                graphics.drawLine(1, 0, 1, 0);
                graphics.drawLine(1, n - 1, 1, n - 1);
                graphics.drawLine(n2 - 1, 0, n2 - 1, 0);
                graphics.drawLine(n2 - 1, n - 1, n2 - 1, n - 1);
                break;
            }
            case 3: 
            case 7: {
                float f = 10.0f * (float)n3 / 10.0f;
                float f3 = 10.0f * (float)n4 / 10.0f;
                int n7 = n / 2;
                for (int i = 1; i < n2 - 1; ++i) {
                    int n8;
                    if (i < n7) {
                        n8 = n7 - i;
                        graphics.setColor(ColorRoutines.lighten(color, (int)((float)n8 * f)));
                    } else if (i == n7) {
                        graphics.setColor(color);
                    } else {
                        n8 = i - n7;
                        graphics.setColor(ColorRoutines.darken(color, (int)((float)n8 * f3)));
                    }
                    graphics.drawLine(2, i + 1, n2 - 3, i + 1);
                }
                graphics.setColor(Theme.scrollTrackBorderColor.getColor());
                graphics.drawLine(0, 0, n2 - 1, 0);
                color = !bl ? Theme.scrollLightDisabledColor.getColor() : Theme.scrollBorderLightColor.getColor();
                graphics.setColor(color);
                graphics.drawLine(1, 2, 1, n - 2);
                graphics.drawLine(n2 - 2, 2, n2 - 2, n - 2);
                Color color3 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 92);
                color = !bl ? Theme.scrollBorderDisabledColor.getColor() : Theme.scrollBorderColor.getColor();
                graphics.setColor(color);
                graphics.drawRect(0, 1, n2 - 1, n - 2);
                graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 92));
                graphics.drawLine(1, 2, 1, 2);
                graphics.drawLine(n2 - 2, 2, n2 - 2, 2);
                graphics.drawLine(1, n - 2, 1, n - 2);
                graphics.drawLine(n2 - 2, n - 2, n2 - 2, n - 2);
                graphics.setColor(color3);
                graphics.drawLine(0, 1, 0, 1);
                graphics.drawLine(n2 - 1, 1, n2 - 1, 1);
                graphics.drawLine(0, n - 1, 0, n - 1);
                graphics.drawLine(n2 - 1, n - 1, n2 - 1, n - 1);
            }
        }
    }

    private void drawXpArrow(Graphics graphics, Dimension dimension) {
        int n = 0;
        int n2 = 0;
        switch (this.direction) {
            case 1: {
                n = (dimension.width - 8) / 2;
                n2 = (dimension.height - 5) / 2;
                graphics.translate(n, n2);
                graphics.drawLine(4, 0, 4, 0);
                graphics.drawLine(3, 1, 5, 1);
                graphics.drawLine(2, 2, 6, 2);
                graphics.drawLine(1, 3, 3, 3);
                graphics.drawLine(5, 3, 7, 3);
                graphics.drawLine(0, 4, 2, 4);
                graphics.drawLine(6, 4, 8, 4);
                graphics.drawLine(1, 5, 1, 5);
                graphics.drawLine(7, 5, 7, 5);
                break;
            }
            case 5: {
                n = (dimension.width - 8) / 2;
                n2 = (dimension.height - 5) / 2;
                graphics.translate(n, n2);
                graphics.drawLine(1, 0, 1, 0);
                graphics.drawLine(7, 0, 7, 0);
                graphics.drawLine(0, 1, 2, 1);
                graphics.drawLine(6, 1, 8, 1);
                graphics.drawLine(1, 2, 3, 2);
                graphics.drawLine(5, 2, 7, 2);
                graphics.drawLine(2, 3, 6, 3);
                graphics.drawLine(3, 4, 5, 4);
                graphics.drawLine(4, 5, 4, 5);
                break;
            }
            case 3: {
                n = (dimension.width - 5) / 2;
                n2 = (dimension.height - 8) / 2;
                graphics.translate(n, n2);
                graphics.drawLine(0, 1, 0, 1);
                graphics.drawLine(0, 7, 0, 7);
                graphics.drawLine(1, 0, 1, 2);
                graphics.drawLine(1, 6, 1, 8);
                graphics.drawLine(2, 1, 2, 3);
                graphics.drawLine(2, 5, 2, 7);
                graphics.drawLine(3, 2, 3, 6);
                graphics.drawLine(4, 3, 4, 5);
                graphics.drawLine(5, 4, 5, 4);
                break;
            }
            case 7: {
                n = (dimension.width - 5) / 2;
                n2 = (dimension.height - 8) / 2;
                graphics.translate(n, n2);
                graphics.drawLine(0, 4, 0, 4);
                graphics.drawLine(1, 3, 1, 5);
                graphics.drawLine(2, 2, 2, 6);
                graphics.drawLine(3, 1, 3, 3);
                graphics.drawLine(3, 5, 3, 7);
                graphics.drawLine(4, 0, 4, 2);
                graphics.drawLine(4, 6, 4, 8);
                graphics.drawLine(5, 1, 5, 1);
                graphics.drawLine(5, 7, 5, 7);
            }
        }
        graphics.translate(-n, -n2);
    }

    public Dimension getPreferredSize() {
        return new Dimension(Theme.scrollSize.getValue(), Theme.scrollSize.getValue());
    }

    private static class ScrollButtonKey {
        private Dimension size;
        private Color c;
        private boolean vertical;
        private boolean pressed;
        private boolean enabled;
        private boolean rollover;

        private ScrollButtonKey(Dimension dimension, boolean bl, Color color, boolean bl2, boolean bl3, boolean bl4) {
            this.size = dimension;
            this.vertical = bl;
            this.c = color;
            this.pressed = bl2;
            this.enabled = bl3;
            this.rollover = bl4;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ScrollButtonKey)) {
                return false;
            }
            ScrollButtonKey scrollButtonKey = (ScrollButtonKey)object;
            return this.size.equals(scrollButtonKey.size) && this.vertical == scrollButtonKey.vertical && this.pressed == scrollButtonKey.pressed && this.enabled == scrollButtonKey.enabled && this.rollover == scrollButtonKey.rollover && this.c.equals(scrollButtonKey.c);
        }

        public int hashCode() {
            return this.size.hashCode() * this.c.hashCode() * (this.pressed ? 1 : 2) * (this.enabled ? 4 : 8) * (this.rollover ? 16 : 32) * (this.vertical ? 64 : 128);
        }
    }
}

